@extends('layouts.master')

@section('content')
    <div>
        <div class="card shadow">
            <div class="card-header  text-Dark">
                <h3 class="mb-0">Stock At Hand Report</h3>
            </div>
            <div class="card-body">
                <form action="{{ route('stock_report.generate') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="date_from">Date From:</label>
                                <input type="date" id="date_from" name="date_from" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="date_to">Date To:</label>
                                <input type="date" id="date_to" name="date_to" class="form-control">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="truck-select">Truck No</label>
                                <select id="truck-select" class="form-control select2">
                                    <option value="">-- Select Truck --</option>
                                    @foreach ($trucks as $truck)
                                        <option value="{{ $truck->id_truck }}">{{ $truck->truck_no }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        {{-- <div class="col-md-6">
                    <div class="form-group">
                        <label>
                            Suppliers
                        </label>
                        <select class="form-control select2" name="suppliers" id="suppliers" required>
                            <option value="">- Select -</option>

                        </select>
                    </div>
                    @error('suppliers')
                        <span class="form-text text-danger">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                    </div> --}}
                        {{-- <div class="col-md-6">
                        <div class="form-group">
                            <label for="supplier">Supplier:</label>
                            <input type="text" id="supplier" name="supplier" class="form-control">
                        </div>
                    </div> --}}
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="main-category-select">Main Category</label>
                                <select id="main-category-select" class="form-control select2" disabled>
                                    <option value="">-- Select Main Category --</option>
                                </select>
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="parent-category-select">Parent Category</label>
                                <select id="parent-category-select" class="form-control select2" disabled>
                                    <option value="">-- Select Parent Category --</option>
                                </select>
                            </div>


                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="child-category-select">Child Category</label>
                                <select id="child-category-select" class="form-control select2" disabled>
                                    <option value="">-- Select Child Category --</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <br>

                    {{-- <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Group By:</h5>
                            <div class="row">
                                <div class="col-6 ">
                                    <div class="form-check form-check-inline">
                                        <input type="radio" class="form-check-input" name="group_by" value="client">
                                        <label class="form-check-label">Client</label>
                                    </div>
                                </div>
                                <div class="col-6 ">
                                    <div class="form-check form-check-inline">
                                        <input type="radio" class="form-check-input" name="group_by" value="product">
                                        <label class="form-check-label">Product</label>
                                    </div>
                                </div>
                                <div class="col-6 ">
                                    <div class="form-check form-check-inline">
                                        <input type="radio" class="form-check-input" name="group_by" value="vehicle_no">
                                        <label class="form-check-label">Vehicle No</label>
                                    </div>
                                </div>
                                <div class="col-6 ">
                                    <div class="form-check form-check-inline">
                                        <input type="radio" class="form-check-input" name="group_by" value="category">
                                        <label class="form-check-label">Category</label>
                                    </div>
                                </div>
                                <div class="col-6 ">
                                    <div class="form-check form-check-inline">
                                        <input type="radio" class="form-check-input" name="group_by" value="none">
                                        <label class="form-check-label">None</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> --}}


                    <br>

                    {{-- <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">View:</h5>
                            <div class="row">
                                <div class="col-6 ">
                                    <div class="form-check form-check-inline">
                                        <input type="radio" class="form-check-input" name="view" value="balance">
                                        <label class="form-check-label">Balance</label>
                                    </div>
                                </div>
                                <div class="col-6 ">
                                    <div class="form-check form-check-inline">
                                        <input type="radio" class="form-check-input" name="view" value="negative">
                                        <label class="form-check-label">Negative</label>
                                    </div>
                                </div>
                                <div class="col-6 ">
                                    <div class="form-check form-check-inline">
                                        <input type="radio" class="form-check-input" name="view"
                                            value="complete_sold">
                                        <label class="form-check-label">Complete Sold</label>
                                    </div>
                                </div>
                                <div class="col-6 ">
                                    <div class="form-check form-check-inline">
                                        <input type="radio" class="form-check-input" name="view" value="all">
                                        <label class="form-check-label">All</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> --}}
                    <br>
                    {{-- <div class="form-check mb-3">
                        <input type="checkbox" class="form-check-input" id="show_summary_only" name="show_summary_only">
                        <label class="form-check-label" for="show_summary_only">Show Summary Only</label>
                    </div> --}}

                    <div class="d-flex justify-content-between">
                        <button type="submit" class="btn btn-primary">OK</button>
                        <button type="reset" class="btn btn-secondary">Cancel</button>
                    </div>
                </form>
            </div>
        </div>

        @if(isset($reportData) && $reportData->isNotEmpty())
        <table class="table">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Stock Quantity</th>
                    <th>Sold Quantity</th>
                    <th>Remaining Quantity</th>
                </tr>
            </thead>
            <tbody>
                @foreach($reportData as $data)
                    <tr>
                        <td>{{ $data->product }}</td>
                        <td>{{ $data->quantity_in_stock }}</td>
                        <td>{{ $data->quantity_sold }}</td>
                        <td>{{ $data->remaining }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p>No data found for the selected filters.</p>
    @endif


    </div>
@endsection

@push('scripts')
    <script>

        $(document).ready(function() {
            $('#truck-select').change(function() {
                const truckId = $(this).val();
                if (truckId) {
                    $.ajax({
                        url: "{{ route('get.main.categories') }}",
                        method: 'POST',
                        data: {
                            truck_id: truckId,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {
                            $('#main-category-select').html(
                                '<option value="">-- Select Main Category --</option>');
                            $.each(data, function(index, category) {
                                $('#main-category-select').append(
                                    `<option value="${category.id_pro_cate_main}">${category.products_category_name}</option>`
                                );
                            });
                            $('#main-category-select').prop('disabled', false);
                        }
                    });
                }
            });

            $('#main-category-select').change(function() {
                const mainCategoryId = $(this).val();
                const truckId = $('#truck-select').val();
                if (mainCategoryId) {
                    $.ajax({
                        url: "{{ route('get.parent.categories') }}",
                        method: 'POST',
                        data: {
                            main_category_id: mainCategoryId,
                            truck_id: truckId,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {
                            $('#parent-category-select').html(
                                '<option value="">-- Select Parent Category --</option>');
                            $.each(data, function(index, category) {
                                $('#parent-category-select').append(
                                    `<option value="${category.id_pro_sub_cat_parent}">${category.name}</option>`
                                );
                            });
                            $('#parent-category-select').prop('disabled', false);
                        }
                    });
                }
            });

            $('#parent-category-select').change(function() {
                const parentCategoryId = $(this).val();
                const truckId = $('#truck-select').val();
                if (parentCategoryId) {
                    $.ajax({
                        url: "{{ route('get.child.categories') }}",
                        method: 'POST',
                        data: {
                            parent_category_id: parentCategoryId,
                            truck_id: truckId,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {
                            $('#child-category-select').html(
                                '<option value="">-- Select Child Category --</option>');
                            $.each(data, function(index, category) {
                                $('#child-category-select').append(
                                    `<option value="${category.id_pro_sub_cat_child}">${category.name}</option>`
                                );
                            });
                            $('#child-category-select').prop('disabled', false);
                        }
                    });
                }
            });
        });


        $(document).ready(function() {
            // Initialize Select2 and Datepicker
            $('#truck-select').select2({
                theme: 'default'
            });
            $('#main-category-select').select2({
                theme: 'default'
            });
            $('#parent-category-select').select2({
                theme: 'default'
            });
            $('#child-category-select').select2({
                theme: 'default'
            });
        });
    </script>
@endpush
